﻿const target = 1000;
  
function Solve: List<string>;
begin
  Result := new List<string>;
  var ops := Arr('+', '-', '*', '/');
  
  // все возможные комбинации чисел (8, 88, 888)
  var numbers := Arr(8, 88, 888);
  
  // перебираем числа:
  for var a := 0 to 8 do
    for var b := 0 to 4 do
      for var c := 0 to 2 do
        if a + 2 * b + 3 * c = 8 then
        begin
          // создаём массив чисел:
          var nums := new List<integer>;
          for var i := 1 to a do nums.Add(8);
          for var i := 1 to b do nums.Add(88);
          for var i := 1 to c do nums.Add(888);
          
          var n := nums.Count;
          
          // генерируем все комбинации операций:
          var totalCombinations := Integer(Power(4, n - 1));
          
          for var comb := 0 to totalCombinations - 1 do
          begin
            var expr := nums[0].ToString;
            var value: real := nums[0];
            var valid := true;
            
            // восстанавливаем операции из номера комбинации:
            var temp := comb;
            for var i := 1 to n - 1 do
            begin
              var opIndex := temp mod 4;
              temp := temp div 4;
              
              var op := ops[opIndex];
              expr += ' ' + op + ' ' + nums[i].ToString;
              
              case op of
                '+': value += nums[i];
                '-': value -= nums[i];
                '*': value *= nums[i];
                '/': 
                  if nums[i] <> 0 then
                    value /= nums[i]
                  else
                  begin
                    valid := false;
                    break;
                  end;
              end;
            end;
            
            if valid and (Abs(value - target) < 0.0001) then
              Result.Add(expr);
          end;
        end;
end;


begin
   WriteLn(' Восемь восьмёрок 2');
   WriteLn;
   
   var solutions := Solve;
   Writeln(' Решений: ', solutions.Count);
   foreach var s in solutions do
      Writeln(' ' + s);
end.